<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Member\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\BaseController;
use Modules\Member\Services\AccountService;

class Account extends BaseController {

	/**
	 * @title 账单列表
	 *
	 * @param AccountService $service
	 * @return void
	 */
	public function index(Request $request, AccountService $service){
		$request->mergeIfMissing(
			['is_user' => 1]
		);

		$this->data['data'] = $service->getDataList($request);
		return $this->data;
	}

	/**
	 * @title 账单统计
	 *
	 * @param AccountService $service
	 * @return void
	 */
	public function count(Request $request, AccountService $service){
		$this->data['data'] = $service->getAccountCount($request);
		return $this->data;
	}

	/**
	 * @title 提现
	 *
	 * @param AccountService $service
	 * @return void
	 */
	public function withdraw(Request $request, AccountService $service){
		try {
			$this->data['data'] = $service->withdrawApply($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return $this->data;
	}
}