<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Member\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\BaseController;
use Modules\Member\Services\AccountService;

class Account extends BaseController{

	/**
	 * @title 账单列表
	 *
	 * @param Request $request
	 * @param AccountService $service
	 * @return void
	 */
	public function index(Request $request, AccountService $service){
		try {
			$this->data['data'] = $service->getDataList($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 添加账单
	 *
	 * @param Request $request
	 * @param AccountService $service
	 * @return void
	 */
	public function add(Request $request, AccountService $service){
		try {
			$this->data['data'] = $service->create($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 修改账单
	 *
	 * @param Request $request
	 * @param AccountService $service
	 * @return void
	 */
	public function edit(Request $request, AccountService $service){
		try {
			$this->data['data'] = $service->update($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 删除账单
	 *
	 * @param Request $request
	 * @param AccountService $service
	 * @return void
	 */
	public function delete(Request $request, AccountService $service){
		try {
			$this->data['data'] = $service->delete($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 通过提现
	 *
	 * @param AccountService $service
	 * @return void
	 */
	public function withdraw(Request $request, AccountService $service){

		try {
			$this->data['data'] = $service->withdraw($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}
		return response()->json($this->data);
	}
}