<?php

namespace Modules\Goods\Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Modules\Auth\Services\MenuService;

class GoodsSeeder extends Seeder {
    /**
     * Run the database seeds.
     */
    public function run(): void {
		$this->addGoodsMenu(); // 商品菜单导入
    }

	/**
	 * @title 商品菜单导入
	 *
	 * @return void
	 */
	public function addGoodsMenu(){
		$permissions = [
			['title' => '商品', 'name' => 'goods', 'path' => '/goods', 'component' => '', 'type' => 'menu', 'sort' => 4, 'children' => [
				['title' => '商品列表', 'name' => 'goods.lists', 'path' => '/goods/lists', 'component' => 'goods/lists', 'type' => 'menu'],
				['title' => '分类列表', 'name' => 'goods.category', 'path' => '/goods/category', 'component' => 'goods/category', 'type' => 'menu'],
				['title' => '品牌列表', 'name' => 'goods.brand', 'path' => '/goods/brand', 'component' => 'goods/brand', 'type' => 'menu'],
				['title' => '规格列表', 'name' => 'goods.spec', 'path' => '/goods/spec', 'component' => 'goods/spec', 'type' => 'menu']
			]]
		];
		return app(MenuService::class)->importMenu($permissions, 0);
	}
}
