<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Goods\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\BaseController;
use Modules\Goods\Services\GoodsService;

class Index extends BaseController {

	/**
	 * @title 商品列表
	 *
	 * @param Request $request
	 * @param GoodsService $service
	 * @return void
	 */
	public function index(Request $request, GoodsService $service){
		try {
			$request->mergeIfMissing(['status' => 1]);
			$this->data['data'] = $service->getDataList($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 商品详情
	 *
	 * @param Request $request
	 * @param GoodsService $service
	 * @return void
	 */
	public function detail(Request $request, GoodsService $service){
		try {
			$this->data['data'] = $service->getData($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}
}
