<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Goods\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\BaseController;
use Modules\Goods\Services\CategoryService;

class Category extends BaseController {

	/**
	 * @title 商品分类列表
	 *
	 * @param Request $request
	 * @param CategoryService $service
	 * @return void
	 */
	public function index(Request $request, CategoryService $service){
		try {
			$request->mergeIfMissing(['status' => 1]);
			$this->data['data'] = $service->getDataList($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}

}
