<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Goods\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\BaseController;
use Modules\Goods\Services\SpecService;

class Spec extends BaseController {

	/**
	 * @title 商品规格
	 *
	 * @param Request $request
	 * @param SpecService $service
	 * @return void
	 */
	public function index(Request $request, SpecService $service){
		try {
			$this->data['data'] = $service->getDataList($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 添加商品规格
	 *
	 * @param Request $request
	 * @param SpecService $service
	 * @return void
	 */
	public function add(Request $request, SpecService $service){
		try {
			$this->data['data'] = $service->create($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 修改商品规格
	 *
	 * @param Request $request
	 * @param SpecService $service
	 * @return void
	 */
	public function edit(Request $request, SpecService $service){
		try {
			$this->data['data'] = $service->update($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 删除商品规格
	 *
	 * @param Request $request
	 * @param SpecService $service
	 * @return void
	 */
	public function delete(Request $request, SpecService $service){
		try {
			$this->data['data'] = $service->delete($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}
}