<?php

namespace Modules\Auth\Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Modules\Auth\Services\MenuService;

class AdminSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void {
		DB::table('auth_admins')->insert([
			'username' => 'admin',
			'nickname' => '超级管理员',
			'email' => 'admin@admin.com',
			'mobile' => '13888888888',
			'password' => Hash::make('admin888'),
			'department_id' => 1,
			'status' => 1,
			'created_at' => date('Y-m-d H:i:s'),
			'updated_at' => date('Y-m-d H:i:s'),
		]);

		DB::table('auth_departments')->insert([
			'title' => '总部',
			'name' => 'root',
			'parent_id' => 0,
			'sort' => 0,
			'description' => '总部',
			'created_at' => date('Y-m-d H:i:s'),
			'updated_at' => date('Y-m-d H:i:s'),
		]);

		DB::table('auth_roles')->insert([
			'title' => '超级管理员',
			'name' => 'admin',
			'description' => '超级管理员',
			'created_at' => date('Y-m-d H:i:s'),
			'updated_at' => date('Y-m-d H:i:s'),
		]);
		// DB::table('auth_permissions')->insert();
		app(MenuService::class)->importMenu($this->getPermissions(), 0);
    }

	public function getPermissions(){
		$permissions = [
			['title' => '首页', 'name' => 'home', 'path' => '/home', 'component' => '', 'type' => 'menu', 'sort' => 0, 'children' => [
				['title' => '仪表盘', 'name' => 'dashboard', 'path' => '/dashboard', 'component' => 'home', 'type' => 'menu', 'affix' => 1],
				['title' => '个人中心', 'name' => 'ucenter', 'path' => '/ucenter', 'component' => 'ucenter', 'type' => 'menu'],
			]],
			['title' => '系统', 'name' => 'system', 'path' => '/system', 'component' => '', 'type' => 'menu', 'sort' => 100, 'children' => [
				['title' => '系统设置', 'name' => 'system.setting', 'path' => '/system/setting', 'component' => 'system/setting', 'type' => 'menu'],
				['title' => '城市数据', 'name' => 'system.area', 'path' => '/system/area', 'component' => 'system/area', 'type' => 'menu'],
				['title' => '字典管理', 'name' => 'system.dic', 'path' => '/system/dic', 'component' => 'system/dic', 'type' => 'menu'],
				['title' => '系统日志', 'name' => 'system.log', 'path' => '/system/log', 'component' => 'system/log', 'type' => 'menu'],
				['title' => '定时任务', 'name' => 'system.cronttab', 'path' => '/system/cronttab', 'component' => 'system/cronttab', 'type' => 'menu'],
			]],
			['title' => '权限', 'name' => 'auth', 'path' => '/auth', 'component' => '', 'type' => 'menu', 'sort' => 99, 'children' => [
				['title' => '用户管理', 'name' => 'auth.user', 'path' => '/auth/user', 'component' => 'auth/user', 'type' => 'menu'],
				['title' => '角色管理', 'name' => 'auth.role', 'path' => '/auth/role', 'component' => 'auth/role', 'type' => 'menu'],
				['title' => '权限管理', 'name' => 'auth.permission', 'path' => '/auth/permission', 'component' => 'auth/permission', 'type' => 'menu'],
				['title' => '部门管理', 'name' => 'auth.department', 'path' => '/auth/department', 'component' => 'auth/department', 'type' => 'menu'],
			]]
		];
		return $permissions;
	}
}
