<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void {
        Schema::create('auth_admins', function (Blueprint $table) {
			$table->id('uid')->unique()->comment('用户ID');
			$table->string('username')->unique()->comment('用户名');
			$table->string('nickname')->nullable()->comment('昵称');
			$table->string('email')->nullable()->comment('邮箱');
			$table->string('mobile')->nullable()->comment('手机号码');
			$table->string('password')->comment('密码');
			$table->string('avatar')->nullable()->comment('头像');
			$table->unsignedBigInteger('department_id')->nullable()->comment('部门id');
			$table->unsignedTinyInteger('gender')->default(1)->comment('性别 1男 2女');
			$table->text('remark')->nullable()->comment('备注,个性签名');
			$table->unsignedTinyInteger('status')->default(1)->comment('状态 1正常 2禁用');
			$table->string('last_login_ip')->nullable()->comment('最后登录ip');
			$table->timestamp('last_login_at')->nullable()->comment('最后登录时间');
			$table->timestamp('email_verified_at')->nullable()->comment('邮箱验证时间');
			$table->timestamp('mobile_verified_at')->nullable()->comment('手机验证时间');
            $table->timestamp('created_at')->nullable()->comment('创建时间');
            $table->timestamp('updated_at')->nullable()->comment('更新时间');
            $table->timestamp('deleted_at')->nullable()->comment('删除时间');

			$table->engine = 'InnoDB';
			$table->charset = 'utf8mb4';
			$table->collation = 'utf8mb4_unicode_ci';
			$table->comment('后台管理员表');
        });
		Schema::create('auth_admins_roles', function (Blueprint $table) {
			$table->unsignedBigInteger('role_id')->comment('角色id');
			$table->unsignedBigInteger('uid')->comment('用户id');
			$table->primary(['role_id', 'uid']);

			$table->engine = 'InnoDB';
			$table->charset = 'utf8mb4';
			$table->collation = 'utf8mb4_unicode_ci';
			$table->comment('后台管理员角色对应表');
		});
		Schema::create('auth_roles', function (Blueprint $table) {
			$table->id()->uniqid()->comment('主键id');
			$table->string('title', 50)->comment('角色名称');
			$table->string('name', 50)->comment('角色标识');
			$table->string('data_range')->default('all')->comment('数据范围 all全部 department本部门 department_sub本部门及以下 self仅自己');
			$table->integer('sort')->default(0)->comment('排序');
			$table->unsignedTinyInteger('status')->default(1)->comment('状态 1正常 2禁用');
			$table->string('description', 255)->nullable()->comment('角色描述');
            $table->timestamp('created_at')->nullable()->comment('创建时间');
            $table->timestamp('updated_at')->nullable()->comment('更新时间');
            $table->timestamp('deleted_at')->nullable()->comment('删除时间');

			$table->engine = 'InnoDB';
			$table->charset = 'utf8mb4';
			$table->collation = 'utf8mb4_unicode_ci';
			$table->comment('后台管理员角色表');
		});
		Schema::create('auth_roles_permissions', function (Blueprint $table) {
			$table->bigInteger('role_id')->unsigned()->comment('角色ID');
			$table->bigInteger('permission_id')->unsigned()->comment('权限ID');
			$table->primary(['role_id', 'permission_id']);

			$table->engine = 'InnoDB';
			$table->charset = 'utf8mb4';
			$table->collation = 'utf8mb4_unicode_ci';
			$table->comment('后台管理员角色权限表');
		});
		Schema::create('auth_permissions', function (Blueprint $table) {
			$table->id()->uniqid()->comment('主键id');
			$table->integer('parent_id')->default(0)->comment('父级id');
			$table->string('title', 50)->comment('权限标题');
			$table->string('name', 50)->comment('权限名称');
			$table->string('icon', 50)->nullable()->comment('图标');
			$table->string('path', 100)->nullable()->comment('权限链接');
			$table->string('redirect', 100)->nullable()->comment('重定向');
			$table->string('component', 200)->nullable()->comment('组件');
			$table->string('type', 20)->default('menu')->comment('类型 menu菜单 button按钮 link外链 iframeIframe');
			$table->string('color', 20)->nullable()->comment('颜色');
			$table->tinyInteger('hidden')->default(0)->comment('是否显示 1显示 2不显示');
			$table->tinyInteger('hiddenBreadcrumb')->default(0)->comment('是否显示面包屑 1显示 2不显示');
			$table->tinyInteger('affix')->default(0)->comment('是否固定 1固定 2不固定');
			$table->tinyInteger('fullpage')->default(0)->comment('是否全屏 1全屏 2不全屏');
			$table->text('apiList')->nullable()->comment('接口列表');
			$table->integer('sort')->default(0)->comment('排序');
			$table->tinyInteger('status')->default(1)->comment('状态 1正常 2禁用');
            $table->timestamp('created_at')->nullable()->comment('创建时间');
            $table->timestamp('updated_at')->nullable()->comment('更新时间');
            $table->timestamp('deleted_at')->nullable()->comment('删除时间');

			$table->engine = 'InnoDB';
			$table->charset = 'utf8mb4';
			$table->collation = 'utf8mb4_unicode_ci';
			$table->comment('权限表');
		});
		Schema::create('auth_departments', function (Blueprint $table) {
			$table->id()->uniqid()->comment('主键id');
			$table->string('parent_id')->default(0)->comment('父级id');
			$table->string('title')->comment('部门名称');
			$table->string('name')->comment('部门标识');
			$table->string('sort')->default(0)->comment('排序');
			$table->tinyInteger('status')->default(1)->comment('状态 1正常 2禁用');
			$table->string('description', 255)->nullable()->comment('部门描述');
            $table->timestamp('created_at')->nullable()->comment('创建时间');
            $table->timestamp('updated_at')->nullable()->comment('更新时间');
            $table->timestamp('deleted_at')->nullable()->comment('删除时间');

			$table->engine = 'InnoDB';
			$table->charset = 'utf8mb4';
			$table->collation = 'utf8mb4_unicode_ci';
			$table->comment('部门表');
		});
	}

    /**
     * Reverse the migrations.
     */
    public function down(): void {
		Schema::dropIfExists('auth_admins');
		Schema::dropIfExists('auth_admins_roles');
		Schema::dropIfExists('auth_roles');
		Schema::dropIfExists('auth_roles_permissions');
		Schema::dropIfExists('auth_permissions');
		Schema::dropIfExists('auth_departments');
    }
};
