<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Auth\Services;

use Modules\Auth\Models\Role;
use App\Support\Tree;

class RoleService {

	/**
	 * @title 获取角色列表
	 *
	 * @param [type] $request
	 * @return void
	 */
	public function getDataList($request) {
		$map = [];

		if ($request->filled('title')) {
			$map[] = ['title', 'like', '%' . $request->input('title') . '%'];
		}
		if ($request->filled('name')) {
			$map[] = ['name', 'like', '%' . $request->input('name') . '%'];
		}

		$query = Role::with(['permissions'])->where($map)->orderBy('id', 'desc');

		if($request->filled('is_tree') && $request->filled('is_tree') == 1){
			$query = $query->get()->toArray();
			$tree = new Tree();
			$data = $tree->list_to_tree($query, 0, 'id', 'parent_id');
		}else{
			$data = [
				'total' => $query->count(),
				'page' => $request->input('page', 1),
				'data' => $query->offset($request->input('offset', 0))->limit($request->input('limit', 10))->get(),
			];
		}
		return $data;
	}

	/**
	 * @title 添加角色
	 *
	 * @param [type] $request
	 * @return void
	 */
	public function create($request) {
		$request->validate([
			'title' => 'required|unique:auth_roles',
			'name' => 'required|alpha_dash:ascii|unique:auth_roles',
		]);
		$data = $request->all();
		$data['status'] = 1;

		return Role::create($data);
	}

	/**
	 * @title 修改角色
	 *
	 * @param [type] $request
	 * @return void
	 */
	public function update($request) {
		$request->validate([
			'title' => 'required|unique:auth_roles,title,' . $request->input('id'),
			'name' => 'required|alpha_dash:ascii|unique:auth_roles,name,' . $request->input('id'),
		]);
		try {
			$role = Role::findOrFail($request->input('id'));
		} catch (\Throwable $th) {
			throw new \Exception("角色不存在！", 1);
		}

		if ($request->filled('title')) {
			$role->title = $request->input('title');
		}
		if ($request->filled('name')) {
			$role->name = $request->input('name');
		}
		if ($request->filled('status')) {
			$role->status = $request->input('status');
		}
		if ($request->filled('sort')) {
			$role->sort = $request->input('sort');
		}

		$role->save();
		return $role;
	}

	/**
	 * @title 删除角色
	 *
	 * @param [type] $request
	 * @return void
	 */
	public function delete($request) {
		if($request->filled('id')){
			try {
				$role = Role::findOrFail($request->input('id'));
			} catch (\Throwable $th) {
				throw new \Exception("角色不存在！", 1);
			}
			$role->permissions()->detach();
			$role->admins()->detach();
			$role->delete();
		}
		if($request->filled('ids')){
			try {
				$role = Role::whereIn('id', $request->input('ids'));
				foreach ($role->get() as $item) {
					$item->permissions()->detach();   //删除关联
					$item->admins()->detach();   //删除关联
				}

				$role->delete();
			} catch (\Throwable $th) {
				throw new \Exception($th->getMessage(), 1);
			}
		}

		return $role;
	}

	/**
	 * @title 角色授权
	 *
	 * @param [type] $request
	 * @return void
	 */
	public function auth($request){
		try {
			$role = Role::with(['permissions'])->findOrFail($request->input('id'));
		} catch (\Throwable $th) {
			throw new \Exception("角色不存在！", 1);
		}


		if($request->filled('data_range')){
			$role->data_range = $request->input('data_range');
		}

		$role->permissions()->sync($request->input('permissions'));
		$role->save();
		return $role;
	}
}
