<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Auth\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\BaseController;
use Modules\Auth\Services\RoleService;

class Role extends BaseController {


	/**
	 * @title 角色列表
	 *
	 * @return \Illuminate\Http\JsonResponse
	 */
	public function index(Request $request, RoleService $service){
		try {
			$this->data['data'] = $service->getDataList($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 添加角色
	 *
	 * @param Request $request
	 * @param Department $service
	 * @return void
	 */
	public function add(Request $request, RoleService $service){
		try {
			$this->data['data'] = $service->create($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 修改角色
	 *
	 * @param Request $request
	 * @param RoleService $service
	 * @return void
	 */
	public function edit(Request $request, RoleService $service){
		try {
			$this->data['data'] = $service->update($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 删除角色
	 *
	 * @param Request $request
	 * @param RoleService $service
	 * @return void
	 */
	public function delete(Request $request, RoleService $service){
		try {
			$this->data['data'] = $service->delete($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 角色权限
	 *
	 * @param Request $request
	 * @param RoleService $service
	 * @return void
	 */
	public function auth(Request $request, RoleService $service){
		try {
			$this->data['data'] = $service->auth($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}
}
