<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Auth\Controllers\Admin;

use App\Http\Controllers\BaseController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use Illuminate\Auth\Events\Login;

class Index extends BaseController {

	/**
	 * @title 用户登录
	 *
	 * @return \Illuminate\Http\JsonResponse
	 */
	public function login() {
		$credentials = request(['username', 'password']);

		$token = auth('admin')->attempt($credentials);

		if (!$token) {
			$this->data['code'] = 0;
			$this->data['message'] = '登录失败！';
		}else{
			$this->data['code'] = 1;
			$this->data['message'] = '登录成功！';
			$this->data['data'] = [
				'access_token' => $token,
				'token_type' => 'bearer',
				'expires_in' => auth('admin')->factory()->getTTL() * 60
			];
			event(new Login('admin', auth('admin')->user(), false));
		}
		return response()->json($this->data);
	}

	/**
	 * @title 获取用户信息
	 *
	 * @return \Illuminate\Http\JsonResponse
	 */
	public function user() {
		try {
			$user = auth('admin')->userOrFail();
			$user->roles = $user->roles()->get();
			$this->data['data'] = $user;
		} catch (\Tymon\JWTAuth\Exceptions\UserNotDefinedException $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 退出
	 * @desc 退出
	 * @method POST
	 * @param \Illuminate\Http\Request $request
	 *
	 * @return \Illuminate\Http\JsonResponse
	 */
	public function logout() {
		auth('admin')->logout();
		$this->data['message'] = '退出成功';
		return response()->json($this->data);
	}

	/**
	 * @title 刷新token
	 * @desc 刷新token
	 * @method POST
	 * @param \Illuminate\Http\Request $request
	 *
	 * @return \Illuminate\Http\JsonResponse
	 */
	public function refresh() {
		$this->data['data'] = auth('admin')->refresh();
		return response()->json($this->data);
	}
}
