<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Ads\Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Modules\Auth\Services\MenuService;

class AdsDatabaseSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
		$this->initMenu();
    }

	public function initMenu(){
		$menuService = app(MenuService::class);

		$operate = DB::table('auth_permissions')->where('name', 'operate')->first();
		if (!$operate) {
			$menu = [
				['title' => '营销', 'name' => 'operate', 'path' => '/operate', 'component' => '', 'type' => 'menu', 'sort' => 5, 'children' => [
					['title' => '广告管理', 'name' => 'operate.ads', 'path' => '/operate/ads', 'component' => 'operate/ads', 'type' => 'menu']
				]]
			];
			$menuService->importMenu($menu, 0);
		}else{
			$menuService->importMenu([
				['title' => '广告管理', 'name' => 'operate.ads', 'path' => '/operate/ads', 'component' => 'operate/ads', 'type' => 'menu']
			], $operate->id);
		}
	}
}
