<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration{
    /**
     * Run the migrations.
     */
    public function up(): void {
		Schema::create('ads', function (Blueprint $table) {
			$table->id()->uniqid()->comment('主键id');
			$table->string('title')->comment('广告标题');
			$table->string('name')->nullable()->comment('广告标识');
			$table->string('group')->nullable()->comment('广告所属板块标识');
			$table->string('description')->nullable()->comment('广告描述');
			$table->string('cover')->nullable()->comment('广告封面');
			$table->string('link')->nullable()->comment('广告链接');
			$table->string('sort')->default(0)->comment('排序');
			$table->tinyInteger('status')->default(1)->comment('状态 1正常 2禁用');
			$table->timestamp('created_at')->nullable()->comment('创建时间');
			$table->timestamp('updated_at')->nullable()->comment('更新时间');

			$table->engine = 'InnoDB';
			$table->charset = 'utf8mb4';
			$table->collation = 'utf8mb4_unicode_ci';
			$table->comment('广告表');
		});
	}

	/**
	 * Reverse the migrations.
	 */
	public function down(): void {
		Schema::dropIfExists('ads');
	}
};