let scannerInstance = null;

export default {
    install(app) {
        const createScanner = () => {
            class BarcodeScanner {
                constructor(options = {}) {
                    // 先绑定事件处理器！！！
                    this.handleKeyDown = this.handleKeyDown.bind(this);

                    // 初始化配置
                    this.options = {
                        endChar: 'Enter',
                        minLength: 3,
                        timeout: 100,
                        ...options
                    };
                    
                    // 状态初始化
                    this.barcode = '';
                    this.timer = null;
                    
                    // 启动监听
                    this.init();
                }

                init() {
                    // document.addEventListener('keydown', this.handleKeyDown);
                    try {
                        document.addEventListener('keydown', this.handleKeyDown);
                    } catch (e) {
                        console.error('条码扫描器初始化失败:', e);
                    }
                }

                // 其他方法保持不变...
                handleKeyDown(event) {
                    if (event.ctrlKey || event.altKey || event.metaKey || event.keyCode === 229) return;

                    const { key } = event;
                    
                    if (key === this.options.endChar) {
                        event.preventDefault();
                        if (this.barcode.length >= this.options.minLength) {
                            this.processBarcode(this.barcode);
                        }
                        this.reset();
                        return;
                    }

                    if (key.length === 1 && !event.repeat) {
                        this.barcode += key;
                        this.resetTimer();
                    }
                }

                resetTimer() {
                    clearTimeout(this.timer);
                    this.timer = setTimeout(() => {
                        if (this.barcode.length >= this.options.minLength) {
                            this.processBarcode(this.barcode);
                        }
                        this.reset();
                    }, this.options.timeout);
                }

                reset() {
                    this.barcode = '';
                    clearTimeout(this.timer);
                }

                processBarcode(barcode) {
                    // 防重复触发（500ms内不处理相同条码）
                    if (this.lastBarcode === barcode && Date.now() - this.lastScan < 500) return;
                    this.lastBarcode = barcode;
                    this.lastScan = Date.now();
                    // 触发事件...

                    const event = new CustomEvent('barcodeScanned', { detail: barcode });
                    document.dispatchEvent(event);
                }

                destroy() {
                    document.removeEventListener('keydown', this.handleKeyDown);
                }
            }
            return new BarcodeScanner();
        };

        app.config.globalProperties.$barcodeScanner = {
            init(options) {
                if (!scannerInstance) {
                    scannerInstance = createScanner(options);
                }
                return scannerInstance;
            },
            destroy() {
                scannerInstance?.destroy();
                scannerInstance = null;
            }
        };
    }
};

//本代码为2.0 版本 在使用中