import { createApp } from 'vue'
import ElementPlus from 'element-plus'
import 'element-plus/dist/index.css'
import 'element-plus/theme-chalk/display.css'
import sent from './sent'
import i18n from './locales'
import router from './router'
import store from './store'
import App from './App.vue'

import './assets/style/main.css'; // 假设 main.css 在 src/assets 目录下

import BarcodeScanner from '@/utils/barcode-scanner';


const app = createApp(App);

//扫码组件
app.use(BarcodeScanner);

app.use(i18n);
app.use(store);
app.use(router);
app.use(ElementPlus);
app.use(sent);

//挂载app
app.mount('#app');
