<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Wechat\Services;

use Illuminate\Support\Facades\Storage;
use EasyWeChat\MiniApp\Application;

class WechatService {

	public function getQrcode($request){
		$request->validate([
			'type' => 'required|in:invite,store',
			'scene' => 'required|string',
			'pages' => 'required|string',
		],[
			'type.required' => '二维码类型不能为空',
			'type.in' => '二维码类型错误',
			'scene.required' => '二维码参数 scene 不能为空',
			'scene.string' => '二维码参数 scene 类型错误',
			'pages.required' => '页面参数 pages 不能为空',
			'pages.string' => '页面参数 pages 类型错误',
		]);
		$config = config('wechat.miniapp');

		$type = $request->input('type', 'invite');
		$uid = auth('api')->user()['uid'];
		$path = "qrcode/{$type}/{$uid}.png";

		if (Storage::disk('public')->exists($path)) {
			return Storage::disk('public')->url($path);
		}

		$app = new Application($config);
		$client = $app->getClient();

		$response = $client->postJson('/wxa/getwxacodeunlimit', [
			'scene' => $request->input('scene'),
			'page' => $request->input('pages'),
			'width' => $request->input('width', 430),
			'check_path' => false,
			'env_version' => $config['env_version'],
		]);
		if ($response->isFailed()) {
			throw new \Exception($response->getContent(), $response->getStatusCode());
		}else{
			Storage::disk('public')->put($path, $response->toStream());
			return Storage::disk('public')->url($path);
		}
	}

	public function getPaymentQrcode($request){
		$config = config('wechat.miniapp');

		$store_id = $request->input('store_id');
		$refresh = $request->input('refresh', 0);
		$path = "qrcode/payment/{$store_id}.png";
		if (Storage::disk('public')->exists($path) && !$refresh) {
			return Storage::disk('public')->url($path);
		}

		$app = new Application($config);
		$client = $app->getClient();

		$response = $client->postJson('/wxa/getwxacodeunlimit', [
			'scene' => 'store_id=' . $store_id,
			'page' => 'pages/store/pay',
			'width' => 430,
			'check_path' => false,
			'env_version' => $config['env_version'],
		]);

		if ($response->isFailed()) {
			throw new \Exception($response->getContent(), $response->getStatusCode());
		}else{
			Storage::disk('public')->put($path, $response->toStream());
			return Storage::disk('public')->url($path);
		}
	}

	public function getServiceQrcode($request){
		$config = config('wechat.miniapp');

		$service_id = $request->input('service_id');
		$refresh = $request->input('refresh', 0);
		$path = "qrcode/service/{$service_id}.png";
		if (Storage::disk('public')->exists($path) && !$refresh) {
			return Storage::disk('public')->url($path);
		}

		$app = new Application($config);
		$client = $app->getClient();

		$response = $client->postJson('/wxa/getwxacodeunlimit', [
			'scene' => 'service_id=' . $service_id,
			'page' => 'pages/store/payScore',
			'width' => 430,
			'check_path' => false,
			'env_version' => $config['env_version'],
		]);

		if ($response->isFailed()) {
			throw new \Exception($response->getContent(), $response->getStatusCode());
		}else{
			Storage::disk('public')->put($path, $response->toStream());
			return Storage::disk('public')->url($path);
		}
	}
}