<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Wechat\Services;

use Illuminate\Support\Facades\Config;
use Illuminate\Support\Str;
use EasyWeChat\MiniApp\Application;
use Modules\Wechat\Models\MemberSocial;
use Modules\Order\Models\Order;

class ShippingService {


	public function pushShipping($order_no, $member_id, $goods_title, $logistics_type = 4){
		$config = Config::get('wechat.miniapp');
		$app = new Application($config);

		$api = $app->getClient();
		$date = new \DateTime('now', new \DateTimeZone('Asia/Shanghai')); // 设置正确的时区
		$openid = MemberSocial::where('member_id', $member_id)->value('openid');

		$data = [
			'order_key' => [
				'order_number_type' => 1,
				'mchid' => $config['mch_id'],
				'out_trade_no' => $order_no,
			],
			'logistics_type' => $logistics_type,
			'delivery_mode' => 1,
			'shipping_list' => [[
				'item_desc'=> $goods_title
			]],
			'payer' => [
				'openid' => $openid,
			],
			'upload_time' => $date->format(\DateTime::RFC3339),
		];
		$response = $api->postJson('/wxa/sec/order/upload_shipping_info', $data);
		return $response;
	}
}