<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
use Illuminate\Support\Facades\Route;

Route::name('system.')->prefix('system')->middleware(['auth.check:api'])->group(function () {
	Route::controller(Modules\System\Controllers\Api\Area::class)->prefix('area')->name('area.')->group(function () {
		Route::get('/', 'index')->name('lists');
	});
	Route::controller(Modules\System\Controllers\Api\Index::class)->prefix('index')->name('index.')->group(function () {
		Route::get('/dict', 'dict')->name('dict');
		Route::get('/config', 'config')->name('config');
		Route::get('/qrcode', 'qrcode')->name('qrcode');
	});
	Route::controller(Modules\System\Controllers\Api\Wechat::class)->prefix('wechat')->name('wechat.')->group(function () {
		Route::get('/serve', 'serve')->name('serve');
		Route::post('/jssdk', 'jssdk')->name('jssdk');
	});
	Route::controller(Modules\System\Controllers\Admin\File::class)->prefix('file')->name('file.')->group(function () {
		Route::post('/upload', 'upload')->name('upload');
	});
});
