<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\System\Services;

use Modules\System\Models\Area;
use App\Support\Tree;

class AreaService {

	/**
	 * @title 区域列表
	 *
	 * @param [type] $request
	 * @return void
	 */
	public function getDataList($request){
		$map = [];
		if($request->filled('title')){
			$map[] = ['title', 'like', '%' . $request->input('title') . '%'];
		}
		if($request->filled('id')){
			$map[] = ['id', '=', $request->input('id')];
		}
		if($request->filled('parent_code')){
			$map[] = ['parent_code', '=', $request->input('parent_code')];
		}

		$query = Area::where($map)->orderBy('id', 'asc');

		if($request->filled('page')){
			$data = [
				'total' => $query->count(),
				'page' => $request->input('page', 1),
				'data' => $query->offset($request->input('offset', 0))->limit($request->input('limit', 10))->get(),
			];
		}else{
			if($request->filled('is_tree') && $request->input('is_tree') == 1){
				$list = $query->get()->toArray();
				$tree = new Tree();
				$data = $tree->list_to_tree($list, 0, 'code', 'parent_code');
			}else{
				$data = $query->get();
			}
		}
		return $data;
	}

	/**
	 * @title 添加区域
	 *
	 * @param [type] $request
	 * @return void
	 */
	public function create($request){

	}

	/**
	 * @title 编辑区域
	 *
	 * @param [type] $request
	 * @return void
	 */
	public function update($request){}
}
