<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
use Illuminate\Support\Facades\Route;

Route::get('/store/index/lists', [Modules\Store\Controllers\Api\Index::class, 'lists'])->name('store.index.lists');

// 店铺路由
Route::name('store.')->prefix('store')->middleware(['auth.check:api'])->group(function () {
	Route::controller(Modules\Store\Controllers\Api\Index::class)->prefix('index')->name('index.')->group(function () {
		Route::get('/detail', 'detail')->name('detail');
		Route::post('/apply', 'apply')->name('apply');
		Route::put('/edit', 'edit')->name('edit');
		Route::get('/mystore', 'mystore')->name('mystore');
		Route::get('/service', 'service')->name('service');
		Route::get('/count', 'count')->name('count');
	});
	Route::controller(Modules\Store\Controllers\Api\Order::class)->prefix('order')->name('order.')->group(function () {
		Route::get('/index', 'index')->name('index');
		Route::get('/detail', 'detail')->name('detail');
		Route::post('/add', 'add')->name('add');
		Route::put('/edit', 'edit')->name('edit');
		Route::delete('/delete', 'delete')->name('delete');
	});
	Route::controller(Modules\Store\Controllers\Api\Category::class)->prefix('category')->name('category.')->group(function () {
		Route::get('/index', 'index')->name('index');
	});

	Route::controller(Modules\Store\Controllers\Api\Payment::class)->prefix('payment')->name('payment.')->group(function () {
		Route::get('/lists', 'lists')->name('lists');
		Route::post('/add', 'add')->name('add');
		Route::post('/transfer', 'transfer')->name('transfer');
		Route::post('/receive', 'receive')->name('receive');
		Route::get('/qrcode', 'qrcode')->name('qrcode');
	});
});
