<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
use Illuminate\Support\Facades\Route;

Route::name('order.')->prefix('order')->middleware(['auth.check:admin'])->group(function () {
	// 订单管理路由配置
	Route::controller(Modules\Order\Controllers\Admin\Order::class)->prefix('index')->name('index.')->group(function () {
		Route::get('/index', 'index')->name('index');
		Route::get('/lists', 'lists')->name('lists');
		Route::post('/add', 'add')->name('add');
		Route::put('/edit', 'edit')->name('edit');
		Route::put('/send', 'send')->name('send');
		Route::get('/detail', 'detail')->name('detail');
		Route::delete('/delete', 'delete')->name('delete');
	});
	Route::controller(Modules\Order\Controllers\Admin\Refund::class)->prefix('refund')->name('refund.')->group(function () {
		Route::get('/index', 'index')->name('index');
		Route::put('/audit', 'audit')->name('audit');
	});
	Route::controller(Modules\Order\Controllers\Admin\Exchange::class)->prefix('exchange')->name('exchange.')->group(function () {
		Route::get('/index', 'index')->name('index');
	});
	Route::controller(Modules\Order\Controllers\Admin\Cashier::class)->prefix('cashier')->name('cashier.')->group(function () {
		Route::get('/index', 'index')->name('index');
		Route::post('/add', 'add')->name('add');
		Route::put('/edit', 'edit')->name('edit');
		Route::post('/simple', 'simple')->name('simple');
	});
});
