<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Order\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\BaseController;
use Modules\Order\Services\RefundService;

class Refund extends BaseController {

	/**
	 * @title 退款列表
	 *
	 * @param Request $request
	 * @param RefundService $service
	 * @return void
	 */
	public function index(Request $request, RefundService $service){
		try {
			$request->mergeIfMissing(['is_user' => 1]);
			$this->data['data'] = $service->getDataList($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}

	public function add(Request $request, RefundService $service){
		try {
			$this->data['data'] = $service->create($request);
			$this->data['message'] = '退款申请已提交，等待审核！';
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 退款详情
	 *
	 * @param Request $request
	 * @param RefundService $service
	 * @return void
	 */
	public function detail(Request $request, RefundService $service){
		try {
			$this->data['data'] = $service->getData($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}
}
