<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Order\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\BaseController;
use Modules\Order\Services\ExchangeService;

class Exchange extends BaseController {

	/**
	 * @title 添加置换收集订单记录
	 *
	 * @param Request $request
	 * @param ExchangeService $service
	 * @return void
	 */
	public function add(Request $request, ExchangeService $service){
		try {
			$this->data['data'] = $service->create($request);
			$this->data['message'] = '添加成功，请耐心等候';
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}
}