<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
use Illuminate\Support\Facades\Route;
use Modules\Member\Controllers\MemberController;

Route::post('/member/login', [Modules\Member\Controllers\Api\Login::class, 'index'])->name('member.login');
Route::post('/member/register', [Modules\Member\Controllers\Api\Login::class, 'register'])->name('member.register');

Route::name('member.')->prefix('member')->middleware(['auth.check:api'])->group(function () {
	Route::get('/user', [Modules\Member\Controllers\Api\Login::class, 'user'])->name('user');
	Route::post('/logout', [Modules\Member\Controllers\Api\Login::class, 'logout'])->name('logout');

	Route::controller(Modules\Member\Controllers\Api\Index::class)->prefix('member')->name('member.')->group(function () {
		Route::get('/index', 'index')->name('index');
		Route::put('/edit', 'edit')->name('edit');
	});

	Route::controller(Modules\Member\Controllers\Api\Promoter::class)->prefix('promoter')->name('promoter.')->group(function () {
		Route::get('/index', 'index')->name('index');
		Route::get('/detail', 'detail')->name('detail');
		Route::get('/info', 'info')->name('info');
		Route::post('/apply', 'apply')->name('apply');
		Route::get('/order', 'order')->name('order');
		Route::get('/store', 'store')->name('store');
	});

	Route::controller(Modules\Member\Controllers\Api\Address::class)->prefix('address')->name('address.')->group(function () {
		Route::get('/index', 'index')->name('index');
		Route::get('/detail', 'detail')->name('detail');
		Route::post('/add', 'add')->name('add');
		Route::put('/edit', 'edit')->name('edit');
		Route::delete('/delete', 'delete')->name('delete');
	});

	Route::controller(Modules\Member\Controllers\Api\Score::class)->prefix('score')->name('score.')->group(function () {
		Route::get('/index', 'index')->name('index');
	});

	Route::controller(Modules\Member\Controllers\Api\Polymer::class)->prefix('polymer')->name('polymer.')->group(function () {
		Route::get('/index', 'index')->name('index');
	});

	Route::controller(Modules\Member\Controllers\Api\Collect::class)->prefix('collect')->name('collect.')->group(function () {
		Route::get('/index', 'index')->name('index');
		Route::post('/add', 'add')->name('add');
		Route::delete('/delete', 'delete')->name('delete');
	});

	Route::controller(Modules\Member\Controllers\Api\Bank::class)->prefix('bank')->name('bank.')->group(function () {
		Route::get('/index', 'index')->name('index');
		Route::post('/add', 'add')->name('add');
		Route::put('/edit', 'edit')->name('edit');
		Route::delete('/delete', 'delete')->name('delete');
	});

	Route::controller(Modules\Member\Controllers\Api\Account::class)->prefix('account')->name('account.')->group(function () {
		Route::get('/index', 'index')->name('index');
		Route::post('/withdraw', 'withdraw')->name('withdraw');
		Route::get('/count', 'count')->name('count');
	});

	Route::controller(Modules\Member\Controllers\Api\Sign::class)->prefix('sign')->name('sign.')->group(function () {
		Route::get('/index', 'index')->name('index');
		Route::get('/add', 'add')->name('add');
	});
});