<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Member\Listeners;

use Modules\Order\Events\OrderRefund;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Modules\Member\Services\ScoreService;

class OrderRefundListener implements ShouldQueue{

	public function handle(OrderRefund $event){
		$refund = $event->refund;
		$order = $event->order;
		$detail = $event->detail;

		// 积分退还
		app(ScoreService::class)->createScore(store_id: $refund->store_id, order_id: $detail->id, member_id: $detail->member_id, amount: $detail->total_integral, type: 'income', type: 'refund', remark: '商品退货退款');
	}
}