<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Member\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\BaseController;
use Modules\Member\Services\MemberService;

class Index extends BaseController {

	/**
	 * @title 用户列表
	 *
	 * @param Request $request
	 * @param MemberService $service
	 * @return void
	 */
	public function index(Request $request, MemberService $service){
		try {
			$request->mergeIfMissing(['is_invite' => 1]);
			$this->data['data'] = $service->getDataList($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}
	/**
	 * @title 手机号绑定
	 *
	 * @param MemberService $service
	 * @return void
	 */
	public function mobile(MemberService $service){
		try {
			$this->data['data'] = $service->bindMobile($this->request->param());
		} catch (\think\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}
		return $this->data;
	}

	/**
	 * @title 微信绑定
	 *
	 * @param MemberService $service
	 * @return void
	 */
	public function upwechat(MemberService $service){
		try {
			$this->data['data'] = $service->updateWechatInfo($this->request->param());
		} catch (\think\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}
		return $this->data;
	}

	public function edit(Request $request, MemberService $service){
		try {
			$request->mergeIfMissing(['uid' => auth('api')->user()['uid']]);
			$this->data['data'] = $service->update($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return $this->data;
	}

	public function promoter(Request $request, MemberService $service){
		try {
			$this->data['data'] = $service->promoter($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return $this->data;
	}
}
