<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Goods\Services;

use Modules\Goods\Models\Category;
use App\Support\Tree;

class CategoryService {

	/**
	 * @title 商品列表
	 *
	 * @param [type] $request
	 * @return void
	 */
	public function getDataList($request){
		$map = [];

		if($request->filled('title')){
			$map[] = ['title', 'like', '%'.$request->input('title').'%'];
		}
		if($request->filled('status')){
			$map[] = ['status', 'like', $request->input('status')];
		}
		if($request->filled('is_recom')){
			$map[] = ['is_recom', '=', $request->input('is_recom')];
		}

		$query = Category::with('ads')->where($map)->orderBy('sort', 'asc')->orderBy('id', 'desc');

		if($request->filled('is_tree') && $request->filled('is_tree') == 1){
			$query = $query->get()->toArray();
			$tree = new Tree();
			$data = $tree->list_to_tree($query, 0, 'id', 'parent_id');
		}else{
			if($request->filled('page')){
				$data = [
					'total' => $query->count(),
					'page' => $request->input('page', 1),
					'data' => $query->offset($request->input('offset', 0))->limit($request->input('limit', 10))->get(),
				];
			}else{
				$data = $query->limit($request->input('limit', 10))->get();
			}
		}
		return $data;
	}

	/**
	 * @title 添加商品
	 *
	 * @param [type] $request
	 * @return void
	 */
	public function create($request){
		$request->validate(
			[
				'title' => 'required|max:255',
				'parent_id' => 'required|integer'
			],
			[
				'title.required' => '请输入分类名称',
				'parent_id.required' => '请选择上级分类',
			]
		);
		$category = new Category;

		foreach ($category->setFilterFields($request->all()) as $key => $value) {
			$category->$key = $value;
		}

		$this->setCategoryCache(true);
		$category->save();
		return $category;
	}

	/**
	 * @title 更新商品
	 *
	 * @param [type] $request
	 * @return void
	 */
	public function update($request){
		$request->validate(
			[
				'title' => 'required|max:255',
				'parent_id' => 'required|integer'
			],
			[
				'title.required' => '请输入分类名称',
				'parent_id.required' => '请选择上级分类',
			]
		);
		$category = Category::findOrFail($request->input('id'));

		foreach ($category->setFilterFields($request->all()) as $key => $value) {
			$category->$key = $value;
		}

		$this->setCategoryCache(true);
		$category->save();
		return $category;
	}

	public function delete($request){
		if($request->filled('id')){
			try {
				$category = Category::findOrFail($request->input('id'));
			} catch (\Throwable $th) {
				throw new \Exception("商品不存在！", 1);
			}
			$category->delete();
		}
		if($request->filled('ids')){
			try {
				$category = Category::whereIn('id', $request->input('ids'));
				$category->delete();
			} catch (\Throwable $th) {
				throw new \Exception($th->getMessage(), 1);
			}
		}
		$this->setCategoryCache(true);
		return $category;
	}

	public function setCategoryCache($refresh = false){
		if (!cache()->has('goods_category') || $refresh) {
			$category = Category::where('status', 1)->orderBy('sort', 'asc')->orderBy('id', 'desc')->get()->toArray();
			cache()->forever('goods_category', $category);
		}
	}
}
