<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Auth\Services;

use Modules\Auth\Models\Department;
use App\Support\Tree;

class DepartmentService {

	/**
	 * @title 获取部门列表
	 *
	 * @param [type] $request
	 * @return void
	 */
	public function getDataList($request) {
		$map = [];

		if ($request->filled('title')) {
			$map[] = ['title', 'like', '%' . $request->input('title') . '%'];
		}
		if ($request->filled('name')) {
			$map[] = ['name', 'like', '%' . $request->input('name') . '%'];
		}
		if ($request->filled('pid')) {
			$map[] = ['parent_id', '=', $request->input('pid')];
		}

		$query = Department::where($map)->orderBy('id', 'desc');

		if($request->filled('is_tree') && $request->filled('is_tree') == 1){
			$query = $query->get()->toArray();
			$tree = new Tree();
			$data = $tree->list_to_tree($query, 0, 'id', 'parent_id');
		}else{
			$data = [
				'total' => $query->count(),
				'page' => $request->input('page', 1),
				'data' => $query->offset($request->input('offset', 0))->limit($request->input('limit', 10))->get(),
			];
		}
		return $data;
	}

	/**
	 * @title 添加部门
	 *
	 * @param [type] $request
	 * @return void
	 */
	public function create($request) {
		$request->validate([
			'title' => 'required|unique:auth_departments',
			'name' => 'required|unique:auth_departments',
		]);
		$data = $request->all();
		$data['status'] = 1;

		return Department::create($data);
	}

	/**
	 * @title 修改部门
	 *
	 * @param [type] $request
	 * @return void
	 */
	public function update($request) {
		try {
			$department = Department::findOrFail($request->input('id'));
		} catch (\Throwable $th) {
			throw new \Exception("部门不存在！", 1);
		}

		if ($request->filled('title')) {
			$department->title = $request->input('title');
		}
		if ($request->filled('name')) {
			$department->name = $request->input('name');
		}
		if ($request->filled('parent_id')) {
			$department->parent_id = $request->input('parent_id');
		}
		if ($request->filled('status')) {
			$department->status = $request->input('status');
		}
		if ($request->filled('sort')) {
			$department->sort = $request->input('sort');
		}

		$department->save();
		return $department;
	}

	/**
	 * @title 删除部门
	 *
	 * @param [type] $request
	 * @return void
	 */
	public function delete($request) {
		if($request->filled('id')){
			try {
				$department = Department::findOrFail($request->input('id'));
			} catch (\Throwable $th) {
				throw new \Exception("角色不存在！", 1);
			}
			$department->delete();
		}
		if($request->filled('ids')){
			try {
				$ids = $request->input('ids');
				$department = Department::whereIn('id', $ids)->delete();
			} catch (\Throwable $th) {
				throw new \Exception($th->getMessage(), 1);
			}
		}

		return $department;
	}
}
