<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Ads\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\BaseController;
use Modules\Ads\Services\AdsService;

class Ads extends BaseController {

	/**
	 * @title 广告列表
	 *
	 * @param Request $request
	 * @param AdsService $service
	 * @return void
	 */
	public function index(Request $request, AdsService $service){
		try {
			$this->data['data'] = $service->getDataList($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}
}
