<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Ads\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\BaseController;
use Modules\Ads\Services\AdsService;

class Ads extends BaseController {

	/**
	 * @title 广告列表
	 *
	 * @param Request $request
	 * @param AdsService $service
	 * @return void
	 */
	public function index(Request $request, AdsService $service) {
		try {
			$this->data['data'] = $service->getDataList($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}
		return response()->json($this->data);
	}

	/**
	 * @title 添加广告
	 *
	 * @param Request $request
	 * @param AdsService $service
	 * @return void
	 */
	public function add(Request $request, AdsService $service) {
		try {
			$this->data['data'] = $service->create($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}
		return response()->json($this->data);
	}

	/**
	 * @title 编辑广告
	 *
	 * @param Request $request
	 * @param AdsService $service
	 * @return void
	 */
	public function edit(Request $request, AdsService $service) {
		try {
			$this->data['data'] = $service->update($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}
		return response()->json($this->data);
	}

	/**
	 * @title 删除广告
	 *
	 * @param Request $request
	 * @param AdsService $service
	 * @return void
	 */
	public function delete(Request $request, AdsService $service) {
		try {
			$this->data['data'] = $service->delete($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}
		return response()->json($this->data);
	}
}
