import { defineConfig } from 'vite'
import path from 'path'
import vue from '@vitejs/plugin-vue'

import tailwindcss from 'tailwindcss'
import autoprefixer from 'autoprefixer'

export default defineConfig({
	base:'./',
	plugins: [vue()],
	resolve: {
		alias: {
			// 设置路径
			'~': path.resolve(__dirname, './'),
			// 设置别名
			'@': path.resolve(__dirname, './src')
		},
		extensions: ['.mjs', '.js', '.ts', '.jsx', '.tsx', '.json', '.vue']
	},
	define: {
		__VUE_I18N_FULL_INSTALL__: true,
		__VUE_I18N_LEGACY_API__: true,
		__INTLIFY_PROD_DEVTOOLS__: false
	},
	server: {
		port: 8081,
		host: true,
		open: false,
		proxy: {
			// https://cn.vitejs.dev/config/#server-proxy
			// '/api': {
			// 	target: 'https://www.fastmock.site/mock/5039c4361c39a7e3252c5b55971f1bd3/api',
			// 	changeOrigin: true,
			// 	rewrite: (p) => p.replace(/^\/api/, '')
			// }
		},
	},
	css: {
		postcss: {
			plugins: [
					tailwindcss(),
        			autoprefixer(),
					{
						postcssPlugin: 'internal:charset-removal',
						AtRule: {
							charset: (atRule) => {
								if (atRule.name === 'charset') {
									atRule.remove();
								}
							}
						}
					}
			],
		},
	},
	build: {
		emptyOutDir: true,
		outDir: 'dist',
		assetsDir: './static',
		minify: 'terser',
		terserOptions: {
			compress: {
				drop_console: true,
				drop_debugger: true
			}
		},
		rollupOptions: {
			input: {
				index: path.resolve(__dirname, 'index.html'),
			},
			// 拆包
			output: {
				chunkFileNames: 'static/js/[name]-[hash].js',
				entryFileNames: 'static/js/[name]-[hash].js',
				assetFileNames(assetInfo){
					const imgExts = ['.png', '.jpg', '.jpeg', '.gif', '.svg', '.webp', '.bmp', '.ico', '.svg']
					if(assetInfo.name.endsWith('.css')){
						return 'static/style/[name]-[hash].css'
					}else if(imgExts.some(ext => assetInfo.name.endsWith(ext))){
						return 'static/images/[name]-[hash].[ext]'
					}else{
						return 'static/other/[name]-[hash].[ext]'
					}
				},
				manualChunks(id) {
					if (id.includes('node_modules')) {
						return id.split('/node_modules/').pop()?.split('/')[0]
					}
				}
			}
		}
	}
})
