import config from "@/config";
import auth from "@/api/module/auth";
import tool from "@/utils/tool";

export default {
	state: {
		//移动端布局
		ismobile: false,
		//布局
		layout: config.LAYOUT,
		//菜单是否折叠 toggle
		menuIsCollapse: config.MENU_IS_COLLAPSE,
		//多标签栏
		layoutTags: config.LAYOUT_TAGS,
		//主题
		theme: config.THEME,
		menu: tool.data.get('MENU') || []
	},
	mutations: {
		SET_ismobile(state, key){
			state.ismobile = key
		},
		SET_layout(state, key){
			state.layout = key
		},
		SET_theme(state, key){
			state.theme = key
		},
		TOGGLE_menuIsCollapse(state){
			state.menuIsCollapse = !state.menuIsCollapse
		},
		TOGGLE_layoutTags(state){
			state.layoutTags = !state.layoutTags
		},
		UPDATA_MENU(state){
			auth.menu.myMenus.get().then(res => {
				state.menu = res.data.menu
				if(res.data.menu.length==0){
					this.islogin = false
					this.$alert("当前用户无任何菜单权限，请联系系统管理员", "无权限访问", {
						type: 'error',
						center: true
					})
					return false
				}
				tool.data.set("MENU", res.data.menu)
				tool.data.set("PERMISSIONS", res.data.permissions)
			})
		}
	}
}
