<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
	/**
	 * Run the migrations.
	 */
	public function up(): void {
		Schema::create('member_social', function (Blueprint $table) {
			$table->id()->uniqid()->comment('主键id');
			$table->unsignedBigInteger('member_id')->comment('会员id');
			$table->string('type', 20)->comment('第三方类型');
			$table->string('openid', 50)->comment('第三方openid');
			$table->string('nickname')->comment('昵称');
			$table->string('avatar')->nullable()->comment('头像');
			$table->string('gender', 10)->nullable()->comment('性别');
			$table->string('country', 50)->nullable()->comment('国家');
			$table->string('province', 50)->nullable()->comment('省份');
			$table->string('city', 50)->nullable()->comment('城市');
			$table->string('language', 50)->nullable()->comment('语言');
			$table->string('unionid', 50)->nullable()->comment('第三方unionid');
			$table->timestamp('created_at')->nullable()->comment('创建时间');
			$table->timestamp('updated_at')->nullable()->comment('更新时间');

			$table->engine = 'InnoDB';
			$table->charset = 'utf8mb4';
			$table->collation = 'utf8mb4_unicode_ci';
			$table->comment('会员第三方登录表');
		});
	}

	/**
	 * Reverse the migrations.
	 */
	public function down(): void {
		Schema::dropIfExists('member_social');
	}
};
