<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\System\Models;

use Illuminate\Database\Eloquent\Casts\Attribute;

class Config extends \App\Models\BaseModel {

	protected $table = 'system_configs';
	protected $fillable = ['values', 'name', 'title', 'group', 'remark', 'type', 'status', 'sort'];
	protected $hidden = ['deleted_at'];

	public function options() : Attribute {
		return Attribute::make(
			get: fn (mixed $value, array $data) => [
				'placeholder'  => $data['title'],
			],
		);
	}

	public function label() : Attribute {
		return Attribute::make(
			get: fn (mixed $value, array $data) => $data['title'],
		);
	}

	public function prop() : Attribute {
		return Attribute::make(
			get: fn (mixed $value, array $data) => $data['title'],
		);
	}
}
