<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\System\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\BaseController;
use Modules\System\Services\AreaService;

class Area extends BaseController {

	/**
	 * @title 获取地区数据
	 *
	 * @param Request $request
	 * @return void
	 */
	public function index(Request $request, AreaService $service){
		try {
			$this->data['data'] = $service->getDataList($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

}
