<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\System\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\BaseController;
use Modules\System\Services\SettingService;

class Setting extends BaseController {

	/**
	 * @title 获取配置列表
	 *
	 * @param Request $request
	 * @param SettingService $service
	 * @return void
	 */
	public function index(Request $request, SettingService $service){
		try {
			$this->data['data'] = $service->getDataList($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 创建配置
	 *
	 * @param Request $request
	 * @param SettingService $service
	 * @return void
	 */
	public function add(Request $request, SettingService $service){
		try {
			$this->data['data'] = $service->create($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 更新配置
	 *
	 * @param Request $request
	 * @param SettingService $service
	 * @return void
	 */
	public function save(Request $request, SettingService $service){
		try {
			$this->data['data'] = $service->update($request);
			$this->data['message'] = "保存成功！";
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 获取配置字段
	 *
	 * @param Request $request
	 * @param SettingService $service
	 * @return void
	 */
	public function fields(Request $request, SettingService $service){
		try {
			$this->data['data'] = $service->getFields($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}
		return response()->json($this->data);
	}
}
