<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\System\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\BaseController;
use Modules\System\Services\DictService;

class Dict extends BaseController {

	/**
	 * @title 字典列表
	 *
	 * @return void
	 */
	public function all(Request $request, DictService $service){
		try {
			$this->data['data'] = $service->getDictionaryAll($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}
		return $this->data;
	}

	/**
	 * @title 字典列表
	 *
	 * @param Request $request
	 * @param DictService $service
	 * @return void
	 */
	public function lists(Request $request, DictService $service){
		try {
			$this->data['data'] = $service->getDataList($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 字段分类
	 *
	 * @param Request $request
	 * @param DictService $service
	 * @return void
	 */
	public function category(Request $request, DictService $service){
		try {
			$this->data['data'] = $service->getCategoryList($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 添加字典
	 *
	 * @param Request $request
	 * @param DictService $service
	 * @return void
	 */
	public function add(Request $request, DictService $service){
		try {
			$this->data['data'] = $service->create($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 修改字典
	 *
	 * @param Request $request
	 * @param DictService $service
	 * @return void
	 */
	public function edit(Request $request, DictService $service){
		try {
			$this->data['data'] = $service->update($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 删除字典
	 *
	 * @param Request $request
	 * @param DictService $service
	 * @return void
	 */
	public function delete(Request $request, DictService $service){
		try {
			$this->data['data'] = $service->delete($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 添加字典分类
	 *
	 * @param Request $request
	 * @param DictService $service
	 * @return void
	 */
	public function addcate(Request $request, DictService $service){
		try {
			$this->data['data'] = $service->createCategory($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 修改字典分类
	 *
	 * @param Request $request
	 * @param DictService $service
	 * @return void
	 */
	public function editcate(Request $request, DictService $service){
		try {
			$this->data['data'] = $service->updateCategory($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 删除字典分类
	 *
	 * @param Request $request
	 * @param DictService $service
	 * @return void
	 */
	public function deleteCate(Request $request, DictService $service){
		try {
			$this->data['data'] = $service->deleteCategory($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}
}
