<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Store\Services;

use Modules\Store\Models\Store;
use Modules\Store\Models\StoreMember;
use Modules\Member\Models\Member;
use Modules\Member\Services\AccountService;

class PartnerService {
	public function getDataList($request){
		$map = [];

		$map[] = ['role', '=', 'partner'];

		if($request->filled('guest_type')){
			$map[] = ['status', 'like', $request->input('guest_type')];
		}

		$query = StoreMember::where($map)->orderBy('id', 'desc');

		$query->where('store_id', function($q){
			$q->select('id')->from('store')->where('status', '=', 1)->where('member_id', '=', auth('api')->user()['uid'])->limit(1);
		});

		if($request->filled('page')){
			$data = [
				'total' => $query->count(),
				'page' => $request->input('page', 1),
				'data' => $query->offset($request->input('offset', 0))->limit($request->input('limit', 10))->get(),
			];
		}else{
			$data = $query->limit($request->input('limit',30))->get();
		}
		return $data;
	}

	public function applyPartner($request){
		$request->mergeIfMissing('member_id', auth('api')->user()['uid']);
		$request->mergeIfMissing('role', 'partner');
		$request->mergeIfMissing('status', 0);

		$partner = StoreMember::where('member_id', '=', $request->input('member_id'))->where('status', '=', 1)->first();
		if($partner){
			throw new \Exception("该身份证已申请", 100);
		}
		$partner = new StoreMember();

		foreach ($store->setFilterFields($request->all()) as $key => $value) {
			$partner->$key = $value;
		}
		$partner->save();
		return $partner;
	}

	/**
	 * @title 同意成为合作伙伴
	 *
	 * @param [type] $request
	 * @return void
	 */
	public function agreePartner($request){
		$partner = StoreMember::find($request->input('id'));
		if(!$partner){
			throw new \Exception("该合作伙伴不存在", 100);
		}
		$partner->status = 1;
		$partner->save();
		return $partner;
	}

	/**
	 * @title 门店订单结算(合作伙伴)
	 *
	 * @param [type] $order
	 * @param [type] $goods
	 * @param [type] $member
	 * @return void
	 */
	public function OrderBalance($order, $goods, $member){
		if(isset($goods['goods']['partner_amount']) && $goods['goods']['partner_amount'] > 0){
			$partners = StoreMember::where('store_id', '=', $order->store_id)->where('status', '=', 1)->pluck('member_id');
			if($partners !== null && count($partners) > 0){
				$partner_uid = $this->getPartner($member->uid, $partners->toArray());
				if($partner_uid){
					app(AccountService::class)->createAccount(store_id: $order->store_id, order_id: $order->id, member_id: $partner_uid, amount: $goods['goods']['partner_amount'], type: 'partner', remark: '店铺合伙人奖励');
				}
			}
		}
	}

	public function getPartner($member_id, $partners){
		$invite_uid = Member::where('uid', '=', $member_id)->value('invite_uid') ?? 0;
		if($invite_uid){
			if(in_array($invite_uid, $partners)){
				return $invite_uid;
			}elseif($invite_uid == $member_id){
				return 0;
			}else{
				$partners = $this->getPartner($invite_uid, $partners);
			}
		}else{
			return 0;
		}
	}
}
