<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Store\Listeners;

use Illuminate\Support\Facades\Log;
use Modules\Member\Services\PolymerService;
use Modules\Store\Events\PaySuccess;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Modules\Member\Services\ScoreService;
use Modules\Member\Services\AccountService;
use Modules\Member\Models\Member;

class PayBlance implements ShouldQueue{

    /**
     * Handle the event.
     */
    public function handle(PaySuccess $event){
        $order = $event->payment;
        $store = $order->store()->first();

        //Log::info("分仓服务费".$store->balance_service_rate);
        if($store->balance_service_rate > 0){//分仓服务费

            $integral = $order->integral;  //店主收入计算
            $polymer_money = $order->polymer_money; //店主收入计算

            //本金
            $cost_money = bcdiv(($order->polymer_money + $order->amount),bcdiv(($store->balance_service_rate + 100),100,2),2);
            //Log::info("分仓服务费本金".$cost_money);
            //分仓服务费
            $balance_service_amount = bcsub(($order->polymer_money + $order->amount), $cost_money, 2);

            $amount = bcsub($order->amount, $balance_service_amount, 2);  //店主收入计算

            if($balance_service_amount > 0 && $store->service_id){
                //Log::info("分仓服务费资金".$balance_service_amount);
                app(AccountService::class)->createAccount(store_id: $store->id, order_id: $order->id, member_id: $store->service_id, type: 'service_income', account_type: 'payment', amount: $balance_service_amount, remark: '店铺收款分仓服务费');
			}

        }else{
            $amount = $order->amount;  //店主收入计算
            $integral = $order->integral;  //店主收入计算
            $polymer_money = $order->polymer_money; //店主收入计算
        }

        //店主收入
        if($amount > 0){
            app(AccountService::class)->createAccount(store_id: $order->store_id, order_id: $order->id, member_id: $store->member_id, type: 'income', account_type: 'payment', amount: $amount, remark: '店铺内客户支付');
		}
        if($integral > 0){
            app(ScoreService::class)->createScore(store_id: $store->id, order_id: $order->id, member_id: $store->member_id, amount: $integral, type: 'income', account_type: 'payment', remark: '店铺内客户支付');
		}
        if($polymer_money > 0){
            app(PolymerService::class)->createPolymer(store_id: $store->id, order_id: $order->id, member_id: $store->member_id, type: 'income', account_type: 'payment', amount: $polymer_money, remark: '店铺内客户支付');
		}
    }

    /**原始
     * Handle the event.
     */
    /*public function handle(PaySuccess $event){
        $order = $event->payment;
        $store = $order->store()->first();


        if($store->invite_uid > 0){
            $invite = Member::with(['level'])->where('uid', $store->invite_uid)->first();
        }else{
            $invite = null;
        }
        if($store->balance_rate > 0){
            $balance_amount = bcmul($order->amount, bcdiv($store->balance_rate, 100, 2), 2);
            $balance_integral = bcmul($order->integral, bcdiv($store->balance_rate, 100, 2), 2);

            $amount = bcsub($order->amount, $balance_amount, 2);  //店主收入计算
            $integral = bcsub($order->integral, $balance_integral, 2);  //店主收入计算

            // 分仓服务费
            $balance_service_amount = bcmul($balance_amount, bcdiv($store->balance_service_rate, 100, 2), 2);
            $balance_service_integral = bcmul($balance_integral, bcdiv($store->balance_service_rate, 100, 2), 2);
            if($balance_service_amount > 0 && $store->service_id){
                app(AccountService::class)->createAccount(store_id: $store->id, order_id: $order->id, member_id: $store->service_id, type: 'service_income', account_type: 'payment', amount: $balance_service_amount, remark: '店铺收款分仓服务费');
            }
            if($balance_service_integral > 0 && $store->service_id){
                app(ScoreService::class)->createScore(store_id: $store->id, order_id: $order->id, member_id: $store->service_id, amount: $balance_service_integral, type: 'service_income', account_type: 'payment', remark: '店铺收款分仓服务费');
            }

            //推广人员服务费
            if($invite){
                if($invite->level->name == 'part_time'){
                    // 兼职代理
                    $balance_service_amount = bcmul($balance_amount, bcdiv(20, 100, 2), 2);
                    $balance_service_integral = bcmul($balance_integral, bcdiv(20, 100, 2), 2);
                    if($balance_service_amount > 0){
                        app(AccountService::class)->createAccount(store_id: $store->id, order_id: $order->id, member_id: $invite->uid, type: 'income', account_type: 'payment', amount: $balance_service_amount, remark: '店铺收款兼职代理服务费');
                    }
                    if($balance_service_integral > 0){
                        app(ScoreService::class)->createScore(store_id: $store->id, order_id: $order->id, member_id: $invite->uid, amount: $balance_service_integral, type: 'income', account_type: 'payment', remark: '店铺收款兼职代理服务费');
                    }
                }else if($invite->level->name == 'signings'){
                    // 签约代理
                    $balance_service_amount = bcmul($balance_amount, bcdiv(30, 100, 2), 2);
                    $balance_service_integral = bcmul($balance_integral, bcdiv(30, 100, 2), 2);
                    if($balance_service_amount > 0){
                        app(AccountService::class)->createAccount(store_id: $store->id, order_id: $order->id, member_id: $invite->uid, type: 'income', account_type: 'payment', amount: $balance_service_amount, remark: '店铺收款签约代理服务费');
                    }
                    if($balance_service_integral > 0){
                        app(ScoreService::class)->createScore(store_id: $store->id, order_id: $order->id, member_id: $invite->uid, amount: $balance_service_integral, type: 'income', account_type: 'payment', remark: '店铺收款签约代理服务费');
                    }
                }
            }
        }else{
            $amount = $order->amount;  //店主收入计算
            $integral = $order->integral;  //店主收入计算
        }

        //店主收入
        if($order->amount > 0){
            app(AccountService::class)->createAccount(store_id: $order->store_id, order_id: $order->id, member_id: $store->member_id, type: 'income', account_type: 'payment', amount: $amount, remark: '店铺内客户支付');
        }
        if($order->integral > 0){
            app(ScoreService::class)->createScore(store_id: $store->id, order_id: $order->id, member_id: $store->member_id, amount: $integral, type: 'income', account_type: 'payment', remark: '店铺内客户支付');
        }
    }*/
}