<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Order\Database\Seeders;

use Illuminate\Database\Seeder;
use Modules\Auth\Services\MenuService;

class OrderDatabaseSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // $this->call([]);
		$this->addOrderMenu();
    }

	public function addOrderMenu(){
		$permissions = [
			['title' => '订单', 'name' => 'order', 'path' => '/order', 'component' => '', 'type' => 'menu', 'sort' => 5, 'children' => [
					['title' => '订单列表', 'name' => 'order.list', 'path' => '/order/list', 'component' => 'order/list', 'type' => 'menu'],
					['title' => '售后订单', 'name' => 'order.refund', 'path' => '/order/refund', 'component' => 'order/refund', 'type' => 'menu'],
					['title' => '置换订单联系记录', 'name' => 'order.exchange', 'path' => '/order/exchange', 'component' => 'order/exchange', 'type' => 'menu'],
				]
			]
		];

		return app(MenuService::class)->importMenu($permissions, 0);
	}
}
