<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Order\Listeners;

use Modules\Order\Events\OrderTake;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Modules\Order\Services\OrderService;
use Modules\Member\Services\ScoreService;
use Modules\Member\Services\AccountService;
use Modules\Member\Models\Member;
use Modules\Order\Models\OrderItem;

class OrderBlance implements ShouldQueue{

	/**
	 * Handle the event.
	 */
	public function handle(OrderTake $event){
		$order = $event->order;
		$item = $event->item;

		$member = $order->member()->first();
		$goods = $item->goods()->first();
		$sku = $item->sku()->first();
		$store = $item->store()->first();

		if($goods->goods_type == 0){
			$config = cache('config');
			if($member->invite_uid > 0){
				$invite = Member::with(['level'])->where('uid', $member->invite_uid)->first();
			}else{
				$invite = null;
			}
			//福利商品的分润
			// 小福利推广人 5
			// 大福利 推广人 100 二级 30  分仓30服务费 ***
			if($goods->is_repeat_buy == 1){
				// 可复购的为大福利套餐
				// 一级推广人 活动100元
				if($member->invite_uid > 0){
					$big_one_amount = intval(data_get($config, 'big_one_amount', 100));
					app(AccountService::class)->createAccount(store_id: $store->id, order_id: $item->id, member_id: $member->invite_uid, type: 'income', account_type: 'order', amount: $big_one_amount, remark: '福利商品一级推广人收入');
				}
				if ($member->invite_uid > 0 && $invite->invite_uid > 0){
					$big_two_amount = intval(data_get($config, 'big_two_amount', 30));
					app(AccountService::class)->createAccount(store_id: $store->id, order_id: $item->id, member_id: $invite->invite_uid, type: 'income', account_type: 'order', amount: $big_two_amount, remark: '福利商品二级推广人收入');
				}

				//分仓服务费
				if($store->service_id){
					$big_service_amount = intval(data_get($config, 'big_service_amount', 30));
					app(AccountService::class)->createAccount(store_id: $store->id, order_id: $item->id, member_id: $store->service_id, type: 'service_income', account_type: 'order', amount: $big_service_amount, remark: '分仓服务费');
				}
			}else{
				// 判断当前订单是否为唯一小福利单
				if(OrderItem::where('goods_id', $item->goods_id)->where('member_id', $item->member_id)->where('order_id', '<', $item->id)->doesntExist()){
					if($member->invite_uid > 0){
						$small_one_amount = intval(data_get($config, 'small_one_amount', 5));
						app(AccountService::class)->createAccount(store_id: $store->id, order_id: $item->id, member_id: $member->invite_uid, type: 'income', account_type: 'order', amount: $small_one_amount, remark: '福利商品一级推广人收入');
					}
				}
			}
		}else{
			if($store->invite_uid > 0){
				$invite = Member::with(['level'])->where('uid', $store->invite_uid)->first();
			}else{
				$invite = null;
			}
			//店铺分润比例
			// 商品 5%-10%的服务器进行分润分配
			// 分仓服务器3%-5%， (兼职代理 20%  全职30%)   剩余归平台
			$balance_amount = 0;
			$balance_integral = 0;
			if($store->balance_rate > 0){
				$balance_amount = bcmul($item->total_price, bcdiv($store->balance_rate, 100, 2), 2);
				$balance_integral = bcmul($item->total_integral, bcdiv($store->balance_rate, 100, 2), 2);

				$amount = bcsub($item->total_price, $balance_amount, 2);  //店主收入计算
				$integral = bcsub($item->total_integral, $balance_integral, 2);  //店主收入计算
				// 分仓服务费
				$balance_service_amount = bcmul($balance_amount, bcdiv($store->balance_service_rate, 100, 2), 2);
				$balance_service_integral = bcmul($balance_integral, bcdiv($store->balance_service_rate, 100, 2), 2);
				if($balance_service_amount > 0 && $store->service_id){
					app(AccountService::class)->createAccount(store_id: $store->id, order_id: $item->id, member_id: $store->service_id, type: 'service_income', account_type: 'order', amount: $balance_service_amount, remark: '分仓服务费');
				}
				if($balance_service_integral > 0 && $store->service_id){
					app(ScoreService::class)->createScore(store_id: $store->id, order_id: $item->id, member_id: $store->service_id, amount: $balance_service_integral, type: 'service_income', account_type: 'order', remark: '分仓服务费');
				}

				//推广人员服务费
				if($invite){
					if($invite->level->name == 'part_time'){
						// 兼职代理
						$balance_service_amount = bcmul($balance_amount, bcdiv(20, 100, 2), 2);
						$balance_service_integral = bcmul($balance_integral, bcdiv(20, 100, 2), 2);
						if($balance_service_amount > 0){
							app(AccountService::class)->createAccount(store_id: $store->id, order_id: $item->id, member_id: $invite->uid, type: 'income', account_type: 'order', amount: $balance_service_amount, remark: '兼职代理服务费');
						}
						if($balance_service_integral > 0){
							app(ScoreService::class)->createScore(store_id: $store->id, order_id: $item->id, member_id: $invite->uid, amount: $balance_service_integral, type: 'income', account_type: 'order', remark: '兼职代理服务费');
						}
					}else if($invite->level->name == 'signings'){
						// 签约代理
						$balance_service_amount = bcmul($balance_amount, bcdiv(30, 100, 2), 2);
						$balance_service_integral = bcmul($balance_integral, bcdiv(30, 100, 2), 2);
						if($balance_service_amount > 0){
							app(AccountService::class)->createAccount(store_id: $store->id, order_id: $item->id, member_id: $invite->uid, type: 'income', account_type: 'order', amount: $balance_service_amount, remark: '签约代理服务费');
						}
						if($balance_service_integral > 0){
							app(ScoreService::class)->createScore(store_id: $store->id, order_id: $item->id, member_id: $invite->uid, amount: $balance_service_integral, type: 'income', account_type: 'order', remark: '签约代理服务费');
						}
					}
				}
			}else{
				$amount = $item->total_price;  //店主收入计算
				$integral = $item->total_integral;  //店主收入计算
			}

			//店主收入
			if($amount > 0){
				app(AccountService::class)->createAccount(store_id: $store->id, order_id: $item->id, member_id: $store->member_id, type: 'income', account_type: 'order', amount: $amount, remark: '店主门店收入');
			}
			if($integral > 0){
				app(ScoreService::class)->createScore(store_id: $store->id, order_id: $item->id, member_id: $store->member_id, amount: $integral, type: 'income', account_type: 'order', remark: '店主门店收入');
			}
		}
	}
}