<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
	/**
	 * Run the migrations.
	 */
	public function up(): void {
		Schema::create('member', function (Blueprint $table) {
			$table->id('uid')->unique()->comment('用户ID');
			$table->string('username')->comment('用户名');
			$table->string('password')->comment('密码');
			$table->string('nickname')->comment('昵称');
			$table->string('mobile')->nullable()->comment('手机号');
			$table->string('email')->nullable()->comment('邮箱');
			$table->string('avatar')->nullable()->comment('头像');
			$table->tinyInteger('gender')->default(0)->comment('性别');
			$table->date('birthday')->nullable()->comment('生日');
			$table->unsignedBigInteger('invite_uid')->default(0)->comment('邀请人UID');
			$table->string('last_login_ip')->nullable()->comment('最后登录IP');
			$table->timestamp('last_login_time')->nullable()->comment('最后登录时间');
			$table->integer('login_count')->default(0)->comment('登录次数');
			$table->integer('level_id')->default(1)->comment('用户等级ID');
			$table->integer('score')->default(0)->comment('积分');
			$table->decimal('money', 10, 2)->default(0.00)->comment('金额');
			$table->tinyInteger('status')->default(1)->comment('状态 1正常 2禁用');
			$table->timestamp('created_at')->nullable()->comment('创建时间');
			$table->timestamp('updated_at')->nullable()->comment('更新时间');

			$table->engine = 'InnoDB';
			$table->charset = 'utf8mb4';
			$table->collation = 'utf8mb4_unicode_ci';
			$table->comment('会员表');
		});
		Schema::create('member_level', function (Blueprint $table) {
			$table->id()->uniqid()->comment('主键id');
			$table->string('title')->comment('会员等级名称');
			$table->string('name')->comment('会员等级标识');
			$table->string('icon')->nullable()->comment('会员等级图标');
			$table->string('remark')->nullable()->comment('会员等级备注');
			$table->string('sort')->default(0)->comment('排序');
			$table->tinyInteger('status')->default(1)->comment('状态');
			$table->timestamp('created_at')->nullable()->comment('创建时间');
			$table->timestamp('updated_at')->nullable()->comment('更新时间');

			$table->engine = 'InnoDB';
			$table->charset = 'utf8mb4';
			$table->collation = 'utf8mb4_unicode_ci';
			$table->comment('会员等级表');
		});
		Schema::create('member_has_level', function (Blueprint $table) {
			$table->unsignedBigInteger('level_id')->comment('等级id');
			$table->unsignedBigInteger('member_id')->comment('用户id');
			$table->primary(['level_id', 'member_id']);

			$table->engine = 'InnoDB';
			$table->charset = 'utf8mb4';
			$table->collation = 'utf8mb4_unicode_ci';
			$table->comment('会员等级关联表');
		});
	}

	/**
	 * Reverse the migrations.
	 */
	public function down(): void {
		Schema::dropIfExists('member');
		Schema::dropIfExists('member_level');
		Schema::dropIfExists('member_has_level');
	}
};
