<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Member\Services;

use Modules\Member\Models\Member;
use Modules\Member\Models\Promoter;
use Modules\Member\Models\MemberLevel;

class PromoterService {

	public function getDataList($request){
		$map = [];

		$query = Promoter::with(['member', 'member.level']);

		if ($request->filled('username')) {
			$map[] = ['username', 'like', '%' . $request->input('username') . '%'];
		}

		$query->where($map)->orderBy($request->input('order', 'id'), $request->input('sort', 'desc'));

		if ($request->filled('page')){
			$data = [
				'total' => $query->count(),
				'page' => $request->input('page', 1),
				'data' => $query->offset($request->input('offset', 0))->limit($request->input('limit', 10))->get(),
			];
		}else{
			$data = $query->get();
		}
		return $data;
	}

	public function create($request){
		$promoter = Promoter::where('member_id', auth('api')->user()['uid'])->first();

		if($promoter){
			throw new \Exception("您已经申请过，请勿重复申请!", 0);
		}

		$promoter = new Promoter();

		$promoter->member_id = auth('api')->user()['uid'];
		foreach ($promoter->setFilterFields($request->all()) as $key => $value) {
			$promoter->$key = $value;
		}

		$promoter->save();
		return $promoter;
	}

	public function getDetail($request){
		$map = [];

		$map[] = ['member_id', '=', auth('api')->user()['uid']];

		return Promoter::with(['member'])->where($map)->first();
	}

	public function getInfo($request){
		$map = [];

		$map[] = ['uid', '=', auth('api')->user()['uid']];

		$member = Member::with(['level'])->select(['uid', 'username', 'nickname', 'mobile', 'avatar', 'score', 'money', 'polymer_money', 'level_id', 'invite_uid'])->where($map)->first();

		if ($member) {
			$member->invite = Member::where('uid', $member->invite_uid)->select(['uid', 'username', 'nickname', 'avatar'])->first();
			$member->store_count = \Modules\Store\Models\Store::where('invite_uid', $member->uid)->count();
			$member->order_count = \Modules\Order\Models\OrderItem::where('member_id', $member->uid)->count();
			$member->sales_count = \Modules\Order\Models\OrderItem::where('member_id', $member->uid)->where('status', '>', 1)->count();
			$member->invite_count = \Modules\Member\Models\Member::where('invite_uid', $member->uid)->count();
		}

		return $member;
	}

	public function audit($request){
		$promoter = Promoter::where('member_id', $request->input('member_id'))->first();

		if(!$promoter){
			throw new \Exception("您还未申请成为推广员，请先申请!", 0);
		}

		if($promoter->status == 1){
			throw new \Exception("您已经申请过，请勿重复申请!", 0);
		}

		$promoter->status = $request->input('status');

		$promoter->save();

		if ($promoter->status == 1) {
			//审核通过
			$level_id = MemberLevel::where('name', 'signings')->value('id');
			$member = $promoter->member()->first();

			$member->level_id = $level_id;
			$member->mobile = $promoter->mobile;
			$member->save();
		}
		return $promoter;
	}

	public function orderBalance($order, $item, $store, $member, $goods, $sku){
	}
}