<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Member\Services;

use Modules\Member\Models\Member;
use Modules\Member\Events\MemberDelete;

class MemberService {

	/**
	 * @title 获取会员列表
	 *
	 * @param [type] $request
	 * @return void
	 */
	public function getDataList($request){
		$map = [];

		if ($request->filled('uid')) {
			$map[] = ['uid', '=', $request->input('uid')];
		}
		if ($request->filled('username')) {
			$map[] = ['username', 'like', '%' . $request->input('username') . '%'];
		}
		if ($request->filled('mobile')) {
			$map[] = ['mobile', 'like', '%' . $request->input('mobile') . '%'];
		}
		if ($request->filled('email')) {
			$map[] = ['email', 'like', '%' . $request->input('email') . '%'];
		}
		if ($request->filled('is_invite') && $request->input('is_invite') == 1) {
			$map[] = ['invite_uid', '=', auth('api')->user()->uid];
		}

		$query = Member::with(['social', 'level'])->where($map);

		$query->orderBy($request->input('order', 'uid'), $request->input('sort', 'desc'));
		if ($request->filled('page')){
			$data = [
				'total' => $query->count(),
				'page' => $request->input('page', 1),
				'data' => $query->offset($request->input('offset', 0))->limit($request->input('limit', 10))->get(),
			];
		}else{
			$data = $query->get();
		}
		return $data;
	}

	/**
	 * @title 创建用户
	 *
	 * @param [type] $request
	 * @return void
	 */
	public function create($request){
		$request->validate([
			'username' => 'required|unique:member'
		]);

		$data = [
			'username' => $request->input('username'),
			'nickname' => $request->input('nickname'),
			'password' => $request->input('password', ''),
		];

		$member = Member::create($data);
		return $member;
	}

	/**
	 * @title 更新用户
	 *
	 * @param [type] $request
	 * @return void
	 */
	public function update($request){
		$request->validate([
			'username' => 'unique:member,username,'.$request->input('uid').',uid',
			'mobile' => 'unique:member,mobile,'.$request->input('uid').',uid',
		],[
			'username.unique' => '用户名已存在！',
			'mobile.unique' => '手机号已存在！',
		]);
		try {
			$members = Member::findOrFail($request->input('uid'));
		} catch (\Throwable $th) {
			throw new \Exception("用户不存在！", 1);
		}

		if ($request->filled('username')) {
			$members->username = $request->input('username');
		}
		if ($request->filled('nickname')) {
			$members->nickname = $request->input('nickname');
		}
		if ($request->filled('avatar')) {
			$members->avatar = $request->input('avatar');
		}
		if ($request->filled('mobile')) {
			$members->mobile = $request->input('mobile');
		}
		if ($request->filled('invite_uid')) {
			$members->invite_uid = $request->input('invite_uid');
		}

		$members->save();

		return $members;
	}

	public function delete($request){
		if(!$request->filled('uid')){
			throw new \Exception("非法操作！", 1);
		}

		$mebers = Member::where('uid', $request->input('uid'))->first();

		if (!$mebers) {
			throw new \Exception("会员不存在！", 1);
		}

		MemberDelete::dispatch($mebers->uid);
		$mebers->delete();

		return true;
	}
}
