<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Member\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\BaseController;
use Modules\Member\Services\AddressService;

class Address extends BaseController {

	/**
	 * 获取用户地址列表
	 *
	 * @param AddressService $service
	 * @return void
	 */
	public function index(Request $request, AddressService $service){
		$request->mergeIfMissing(
			['is_user' => 1]
		);

		$this->data['data'] = $service->getDataList($request);

		return $this->data;
	}

	/**
	 * 添加用户地址
	 *
	 * @param AddressService $service
	 * @return void
	 */
	public function add(Request $request, AddressService $service){
		try {
			$this->data['data'] = $service->create($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return $this->data;
	}

	public function edit(Request $request, AddressService $service){
		try {
			$this->data['data'] = $service->update($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}
		return $this->data;
	}

	/**
	 * 删除用户地址
	 *
	 * @param AddressService $service
	 * @return void
	 */
	public function delete(Request $request, AddressService $service){
		try {
			$this->data['data'] = $service->delete($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return $this->data;
	}

	public function detail(Request $request, AddressService $service){
		try {
			$this->data['data'] = $service->getData($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return $this->data;
	}
}
