<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Member\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\BaseController;
use Modules\Member\Services\PolymerService;

class Polymer extends BaseController{

	/**
	 * @title 聚物通列表
	 *
	 * @param Request $request
	 * @param PolymerService $service
	 * @return void
	 */
	public function index(Request $request, PolymerService $service){
		try {
			$this->data['data'] = $service->getDataList($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 添加聚物通
	 *
	 * @param Request $request
	 * @param PolymerService $service
	 * @return void
	 */
	public function add(Request $request, PolymerService $service){
		try {
			$this->data['data'] = $service->createPolymer(store_id: 0, order_id: 0, member_id: $request->input('member_id'), amount: $request->input('amount'), type: $request->input('type'), account_type: 'system', remark: $request->input('remark'));
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 修改聚物通
	 *
	 * @param Request $request
	 * @param PolymerService $service
	 * @return void
	 */
	public function edit(Request $request, PolymerService $service){
		try {
			$this->data['data'] = $service->update($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 删除聚物通
	 *
	 * @param Request $request
	 * @param PolymerService $service
	 * @return void
	 */
	public function delete(Request $request, PolymerService $service){
		try {
			$this->data['data'] = $service->delete($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}
}