<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Member\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\BaseController;
use Modules\Member\Services\LevelService;

class Level extends BaseController{

	/**
	 * @title 会员列表
	 *
	 * @param Request $request
	 * @param LevelService $service
	 * @return void
	 */
	public function index(Request $request, LevelService $service){
		try {
			$this->data['data'] = $service->getDataList($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 添加会员
	 *
	 * @param Request $request
	 * @param LevelService $service
	 * @return void
	 */
	public function add(Request $request, LevelService $service){
		try {
			$this->data['data'] = $service->create($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 修改会员
	 *
	 * @param Request $request
	 * @param LevelService $service
	 * @return void
	 */
	public function edit(Request $request, LevelService $service){
		try {
			$this->data['data'] = $service->update($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 删除会员
	 *
	 * @param Request $request
	 * @param LevelService $service
	 * @return void
	 */
	public function delete(Request $request, LevelService $service){
		try {
			$this->data['data'] = $service->delete($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}
}
