<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Goods\Models;

use App\Models\BaseModel;

class Category extends BaseModel {

	protected $table = 'goods_category';
	protected $fillable = ['title', 'parent_id', 'description', 'cover', 'icon', 'keywords', 'sort','status'];
	// protected $hidden = ['deleted_at'];

	protected function casts(): array {
		return [
			'parent_id' => 'integer',
			'sort' => 'integer',
			'status' => 'integer',
			'created_at' => 'datetime:Y-m-d H:i:s',
			'updated_at' => 'datetime:Y-m-d H:i:s',
		];
	}

	public function ads(){
		return $this->hasMany('Modules\Ads\Models\Ads', 'group', 'ads_place');
	}
}
