<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Auth\Models;

use Illuminate\Database\Eloquent\Casts\Attribute;

class Permission extends \App\Models\BaseModel {

	protected $table = 'auth_permissions';
	protected $fillable = ['title', 'name', 'parent_id', 'hiddenBreadcrumb', 'hidden', 'affix', 'color', 'fullpage', 'icon', 'status', 'sort'];
	protected $hidden = ['deleted_at'];

	public function meta() : Attribute {
		return Attribute::make(
			get: fn (mixed $value, array $data) => [
				'id' => $data['id'],
				'parent_id' => $data['parent_id'],
				'title' => $data['title'],
				'hiddenBreadcrumb' => $data['hiddenBreadcrumb'],
				'hidden' => $data['hidden'],
				'affix' => $data['affix'],
				'color' => $data['color'],
				'fullpage' => $data['fullpage'],
				'icon' => isset($data['icon']) && $data['icon'] ? $data['icon'] : 'el-icon-document',
			],
		);
	}

	public function roles(){
		return $this->belongsToMany(Role::class, 'auth_roles_permissions', 'permission_id', 'role_id');
	}
}
