<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Auth\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\BaseController;
use Modules\Auth\Services\UsersService;

class Users extends BaseController {


	/**
	 * @title 用户列表
	 *
	 * @return \Illuminate\Http\JsonResponse
	 */
	public function index(Request $request, UsersService $service){
		try {
			$this->data['data'] = $service->getDataList($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 添加用户
	 *
	 * @param Request $request
	 * @param UsersService $service
	 * @return void
	 */
	public function add(Request $request, UsersService $service){
		try {
			$this->data['data'] = $service->create($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 修改用户
	 *
	 * @param Request $request
	 * @param UsersService $service
	 * @return void
	 */
	public function edit(Request $request, UsersService $service){
		try {
			$this->data['data'] = $service->update($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 删除用户
	 *
	 * @param Request $request
	 * @param UsersService $service
	 * @return void
	 */
	public function delete(Request $request, UsersService $service){
		try {
			$this->data['data'] = $service->delete($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 修改密码
	 *
	 * @param Request $request
	 * @param UsersService $service
	 * @return void
	 */
	public function passwd(Request $request, UsersService $service){
		try {
			$this->data['data'] = $service->upPassword($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 角色分配
	 *
	 * @param Request $request
	 * @param UsersService $service
	 * @return void
	 */
	public function uprole(Request $request, UsersService $service){
		try {
			$this->data['data'] = $service->uprole($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}
}
